#include "pvmuser.h"
#include "pvm_consts.h"
#include "xab.h"

#define MAX(a,b) ((a) > (b) ? (a) : (b))

void
FUNCTION(fputstring) ARGS(`STRING_ARG(p), cc')
int *cc;
STRING_ARG_DECL(p);
{
	static char *buf = 0;
	static int buflen = 0;
	char *malloc();

	/*
	 * Have to have a NUL at the end of the string, and
	 * the only way to do this portably is to copy the whole string
	 * into a malloc'ed buffer.  We keep the buffer around for
	 * future use rather than free'ing it each time we're done.
	 */
	if (!buf)
		buf = malloc(buflen = STRING_LEN(p) + 1);
	else
		if (STRING_LEN(p) + 1 > buflen) {
			buflen = MAX(STRING_LEN(p) + 1, buflen * 2);
			/* don't use realloc; it might cause old data to be copied */
			free(buf);
			buf = malloc(buflen);
		}
	if (!buf) {
		*cc = pvm_uerr("fputstring", PvmNoMem);
		return;
	}
	strncpy(buf, STRING_PTR(p), STRING_LEN(p));
	buf[STRING_LEN(p)] = '\0';
	/*
	 * this does the same thing as putstring (buf) as long as
	 * there are no NULs in the string until the end.  However,
	 * using putbytes() avoids an extra strcpy() and will transmit
	 * the NULs to the other end if it's FORTRAN.
	 */
	*cc = putbytes(buf, STRING_LEN(p) + 1);
}
